	function [dev,err] = forcing(dev,nfcns,iext,des,wt,w,idev,kk)

	% <---------------------------------------------------------------<< DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m
	% <---------------------------------------------------------------<< DH <<<

% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	 
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
		
	% <--- edited Jan-29-2007 with MATLAB R2006a ---------------------<< DH <<<
	
	devi = dev;
	nrip = nfcns+1;
	desir = des(iext(1:length(iext)-1));
	water = wt(iext(1:length(iext)-1));
	
	if (devi < 2E-6)
		isearch = 0;        % initial search
	else
		isearch = 1;
	end
	iter = 0;flag1 = 0;
	while (flag1 == 0)
		flag1 = 1;
		f1 = forcehelp(nrip,desir,water,w,devi,kk,idev); % f1 = dev2
		if (f1 < 0)              % iext point is on the other side of axis, so
			% this band has too many iext points
			if (isearch ~= 0)
				devi = 1E-6;isearch = 0;flag1 = 0; % initial value for deviation
			elseif (devi > 3)                      % devi(ation) is too large, cannot
				err = 4;return;                    % find solution using current inital
				% values
			else
				devi = 1.2*devi;                   % using smaller factor sometimes
				%devi = 1.0117*devi;  %ex2         % gives solution.
				flag1 = 0;
			end
		end
		if (flag1 == 1)
			dev1 = devi;
			dev2 = dev1+1E-6;
			g2 = forcehelp(nrip,desir,water,w,dev2,kk,idev); % g2 = dev2
			if (g2 > f1)
				if (isearch ~= 0)
					devi = 1E-6;isearch = 0;flag1 = 0;
				elseif (devi > 3)                  % devi(ation) is too large
					err = 5;return;
				else
					devi = 1.2*devi;flag1 = 0;
				end
			end
		end
		if (flag1 == 1) %1
			f1 = f1-dev1;f2 = g2-dev2;
			dev3 = dev2-(dev2-dev1)*f2/(f2-f1);
			flag4 = 0; %while flag4
			while (flag4  == 0)
				g3 = forcehelp(nrip,desir,water,w,dev3,kk,idev); % g3 = dev2
				iter = iter+1;
				if (iter > 500) 
					err = 6;return;
				end
				flag4 = 1;
				if ((dev3-dev2)*(g3-g2) > 0)
					if (abs(dev3-g3) < 1E-6)
						dev = dev3;
						err = 0;return
					end
					if (abs(dev3-dev2) < 1E-7)
						if (isearch ~= 0)
							devi = 1E-6;isearch = 0;flag1 = 0;
						elseif (devi > 3)
							err = 7;return;
						else
							devi = 1.2*devi;flag1 = 0;
						end
						break; % to break while-loop
					end
					dev3 = (dev3+dev2)/2;            
					flag4 = 0;
				end
				if (flag4 == 1)
					f1 = f2;f2 = g3-dev3;g2 = g3;
					dev1 = dev2;dev2 = dev3;
					if (abs((dev1-dev2)/(dev1+dev2)) > 1E-8)
						dev3 = dev2-(dev2-dev1)*f2/(f2-f1);
						flag4 = 0;
					end
				end
			end % while (flag4 == 0)
		end
	end % while (flag1 == 0)
	dev = dev3;
	err = 0;
